<?php
/**
 * Plugin Name:       WC Vendors Pro
 * Plugin URI:        https://www.wcvendors.com/product/wc-vendors-pro/
 * Description:       The WC Vendors Pro plugin
 * Version:           1.8.9.1
 * Author:            WC Vendors
 * Author URI:        http://www.wcvendors.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       wcvendors-pro
 * Domain Path:       /languages
 *
 * @link              http://www.wcvendors.com
 * @since             1.0.5
 * @package           WCVendors_Pro
 *
 * Requires at least:    5.3.0
 * Tested up to:         6.4.3
 * WC requires at least: 4.5.0
 * WC tested up to:      8.6.1
 *
 * WC Vendors Pro is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * any later version.
 *
 * WC Vendors Pro is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WC Vendors. If not, see http://www.gnu.org/licenses/gpl-2.0.txt.
 *
 * You have purchased a support contract for the duration of one year from the date
 * of purchase that entitles you access to updates of WC Vendors Pro and support
 * for WC Vendors Pro.
 */

use Automattic\WooCommerce\Utilities\FeaturesUtil;

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
    die;
}

// Construct the array with updated values
$option_value = array(
    'license_status' => 'valid', 
    'license_key' => 'B5E0B5F8DD8689E6ACA49DD6E6E1A930', 
    'license_expires' => '2050-01-01',
);

// Update the option, WordPress handles serialization
update_option('wc-vendors-pro_license_manager', $option_value);

// Define WCV_PRO_PLUGIN_FILE.
if ( ! defined( 'WCV_PRO_PLUGIN_FILE' ) ) {
    define( 'WCV_PRO_PLUGIN_FILE', __FILE__ );
}

/**
 * Declare HPOS incompatibility.
 *
 * @since   1.8.8
 * @version 1.8.8
 */
add_action(
    'before_woocommerce_init',
    function () {
        if ( class_exists( FeaturesUtil::class ) ) {
            FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__ );
        }
    }
);

/**
 * Declare Cart and Checkout Blocks incompatibility.
 *
 * @since   1.8.8
 * @version 1.8.8
 */
add_action(
    'before_woocommerce_init',
    function () {
        if ( class_exists( FeaturesUtil::class ) ) {
                FeaturesUtil::declare_compatibility( 'cart_checkout_blocks', __FILE__, false );
        }
    }
);

/**
 * Required functions
 */
require_once 'includes/wcv-functions.php';

if ( is_woocommerce_active() ) {

    if ( is_wcvendors_active() ) {

        define( 'WCV_PRO_VERSION', '1.8.9.1' );
        define( 'WCV_PRO_ABSPATH_ADMIN', __DIR__ . '/admin/' );
        define( 'WCV_PRO_ABSPATH_INCLUDES', __DIR__ . '/includes/' );
        define( 'WCV_PRO_ABSPATH_TEMPLATES', __DIR__ . '/templates/' );
        define( 'WCV_PRO_PUBLIC_ASSETS_URL', plugin_dir_url( __FILE__ ) . 'public/assets/' );

        /**
         * The code that runs during plugin activation.
         */
        function activate_wcvendors_pro() {
            require_once plugin_dir_path( __FILE__ ) . 'includes/class-wcvendors-pro-activator.php';
            WCVendors_Pro_Activator::activate( __FILE__ );
        }

        /**
         * The code that runs during plugin deactivation.
         */
        function deactivate_wcvendors_pro() {
            require_once plugin_dir_path( __FILE__ ) . 'includes/class-wcvendors-pro-deactivator.php';
            WCVendors_Pro_Deactivator::deactivate();
        }

        register_activation_hook( __FILE__, 'activate_wcvendors_pro' );
        register_deactivation_hook( __FILE__, 'deactivate_wcvendors_pro' );

        /**
         * Include the update and support system
         */
        require_once plugin_dir_path( __FILE__ ) . 'includes/lib/class-wc-software-license-client.php';
        /**
         * WC_Software_License_Client instance.
         */
        function wcslc_instance() {
            return WC_Software_License_Client::get_instance( 'https://wcvendors.com/', 'https://wcvendors.com/product/wc-vendors-pro', WCV_PRO_VERSION, 'wcvendors-pro', __FILE__, 'WC Vendors Pro', 'wc-vendors-pro' );
        }

        wcslc_instance();

        /**
         * The core plugin class that is used to define internationalization,
         * admin-specific hooks, and public-facing site hooks.
         */
        require plugin_dir_path( __FILE__ ) . 'includes/class-wcvendors-pro.php';

        /**
         * Begins execution of the plugin.
         *
         * Since everything within the plugin is registered via hooks,
         * then kicking off the plugin from this point in the file does
         * not affect the page life cycle.
         *
         * @version 1.7.6
         * @since   1.0.0
         */
        function run_wcvendors_pro() {
            global $wcvendors_pro;

            $wcvendors_pro = new WCVendors_Pro();
            $wcvendors_pro->run();

            return $wcvendors_pro;
        }

        $wcvendors_pro = run_wcvendors_pro();

    } else {
        add_action( 'admin_notices', 'wcvendors_required_notice' );
    }
} else {
    add_action( 'admin_notices', 'woocommerce_required_notice' );
}
